package gov.va.med.mhv.usermgmt.util.mvi;

import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CD;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02QUQIMT021001UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02ParameterList;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02PatientIdentifier;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02QueryByParameter;
import gov.va.med.mhv.mvi.xsd.TEL;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document.PRPAIN201309UV02;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;

public class CreateMVIGetCorrespondingRequest {
	
	
	private static final Log LOG = LogFactory.getLog(CreateMVIGetCorrespondingRequest.class);
	/**
	 * @param args
	 */
	public static Object createMVIGetCorrespondingRequest(String icn) {
		// Configuration Properties
		MviProperties properties = MviProperties.getInstance();
		
		if(properties.getIsMviMockCorrespondingEnabled())
			return createMockGetCorrespondingXMLRequest(); 
		
		PRPAIN201309UV02Document root1309Doc = PRPAIN201309UV02Document.Factory.newInstance();
		
		PRPAIN201309UV02 root1309Req = root1309Doc.addNewPRPAIN201309UV02();
		
		root1309Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);
		
		II rootId = root1309Req.addNewId();
		rootId.setRoot(properties.getMviRootId());
		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();
		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue) );
		
		
		TS creationTime = root1309Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());
		/*
		 <urn:creationTime value="20070428150301"/>
   		 <urn:interactionId root="2.16.840.1.113883.1.6" extension="PRPA_IN201309UV02"/>
		 */
		II interactionId = root1309Req.addNewInteractionId();
		interactionId.setRoot(properties.getMviInteractionId()); interactionId.setExtension(MviConstants.MVI_INTERACTION_CORRES_TYPE);
		/*
		 <urn:processingCode code="T"/>
		 */
		CS processingCode = root1309Req.addNewProcessingCode();
		if(properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		/*
		 <urn:processingModeCode code="T"/>
		 */
		CS processingModeCode = root1309Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_MODE_CODE);
		/*
		 <urn:acceptAckCode code="AL"/>
		 */
		CS acceptAckCode = root1309Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
		<urn:receiver typeCode="RCV">
	        <urn:device classCode="DEV" determinerCode="INSTANCE">
	            <urn:id root="2.16.840.1.113883.4.349"/>
	            <urn:telecom value="http://servicelocation/PDQuery"/>
	        </urn:device>
    	</urn:receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1309Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot(properties.getVaOidValue());
		TEL deviceTelecom = device.addNewTelecom();
		deviceTelecom.setValue("http://servicelocation/PDQuery");
		/*
		<urn:sender typeCode="SND">
        	<urn:device classCode="DEV" determinerCode="INSTANCE">
            	<urn:id extension="200MH" root="2.16.840.1.113883.3.933"/>
        	</urn:device>
    	</urn:sender>
		 */
		MCCIMT000100UV01Sender sender = root1309Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());

		/*
		<urn:controlActProcess classCode="CACT" moodCode="EVN">
        <urn:code codeSystem="2.16.840.1.113883.1.6" code="PRPA_TE201305UV02"/>
		 */
		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1309Req.addNewControlActProcess(); 
		root1309Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem(properties.getMviInteractionId());controlCode.setCode(MviConstants.MVI_CORRES_CONTROL_CODE);
		/*
        <urn:queryByParameter>
            <urn:queryId root="2.16.840.1.113883.3.933" extension="18204"/>
            <urn:statusCode code="new"/>
            <urn:responsePriorityCode code="l"/>
            <urn:parameterList>
                <urn:patientIdentifier>
                    <urn:value root="2.16.840.1.113883.4.349" extension="1008540319V974321^NI"/>
                    <urn:semanticsText>Patient.Id</urn:semanticsText>
                </urn:patientIdentifier>
            </urn:parameterList>
        </urn:queryByParameter>
		 */
		PRPAMT201307UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot(properties.getMviRootId()); controlQueryId.setExtension(String.valueOf(mcidUniqValue));
		
		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode(MviConstants.MVI_NEW_STATUS_CODE);
		CS controlResPriorityCode = controlQueryParameter.addNewResponsePriorityCode();
		controlResPriorityCode.setCode("l");
		PRPAMT201307UV02ParameterList controlQueryParameterList = controlQueryParameter.addNewParameterList();
		
		PRPAMT201307UV02PatientIdentifier patientIdentifier = controlQueryParameterList.addNewPatientIdentifier();
		II patientIdentifierValue = patientIdentifier.addNewValue();
		
		//String ICN="1012581128V549975";
		String identifierExtension ="^NI";
		String identfierExtensionFinal = icn.concat(MviConstants.CARET_SYMBOL + properties.getMviNationalIdentifier() + MviConstants.CARET_SYMBOL + properties.getMviReceivingFacilityId() + MviConstants.CARET_SYMBOL + properties.getMviFacilityAssignAuthority());
		patientIdentifierValue.setRoot(properties.getVaOidValue()); patientIdentifierValue.setExtension(identfierExtensionFinal);
		patientIdentifier.setSemanticsText("Patient.Id");
		
		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1309Doc.xmlText(options));

        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);
        
        boolean valid =root1309Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1309 Get Corresponding Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
          //CR1964 - Make sure that the code doesn't go into the infinite loop.
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }
      return root1309Doc.xmlText();
		
	}
	private static Object createMockGetCorrespondingXMLRequest() {
		
		PRPAIN201309UV02Document root1309Doc = PRPAIN201309UV02Document.Factory.newInstance();
		
		PRPAIN201309UV02 root1309Req = root1309Doc.addNewPRPAIN201309UV02();
		
		root1309Req.setITSVersion("XML_1.0");
		
		II rootId = root1309Req.addNewId();
		rootId.setRoot("2.16.840.1.113883.3.933");
		rootId.setExtension("MCID-12345");
		
		TS creationTime = root1309Req.addNewCreationTime();
		creationTime.setValue("20070428150301");
		
		II interactionId = root1309Req.addNewInteractionId();
		interactionId.setRoot("2.16.840.1.113883.1.6"); interactionId.setExtension("PRPA_IN201309UV02");
		
		CS processingCode = root1309Req.addNewProcessingCode();
		processingCode.setCode("T");
		CS processingModeCode = root1309Req.addNewProcessingModeCode();
		processingModeCode.setCode("T");
		
		CS acceptAckCode = root1309Req.addNewAcceptAckCode();
		acceptAckCode.setCode("AL");
		
		MCCIMT000100UV01Receiver receiver = root1309Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot("2.16.840.1.113883.4.349");
		TEL deviceTelecom = device.addNewTelecom();
		deviceTelecom.setValue("http://servicelocation/PDQuery");
		
		MCCIMT000100UV01Sender sender = root1309Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode("INSTANCE");
		II senderId = senderDevice.addNewId();
		senderId.setExtension("200MH");
		senderId.setRoot("2.16.840.1.113883.3.933");
		
		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1309Req.addNewControlActProcess(); 
		root1309Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem("2.16.840.1.113883.1.6");controlCode.setCode("PRPA_TE201305UV02");
		
		PRPAMT201307UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot("2.16.840.1.113883.3.933"); controlQueryId.setExtension("18204");
		
		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode("new");
		CS controlResPriorityCode = controlQueryParameter.addNewResponsePriorityCode();
		controlResPriorityCode.setCode("l");
		PRPAMT201307UV02ParameterList controlQueryParameterList = controlQueryParameter.addNewParameterList();
		
		PRPAMT201307UV02PatientIdentifier patientIdentifier = controlQueryParameterList.addNewPatientIdentifier();
		II patientIdentifierValue = patientIdentifier.addNewValue();
		
		String ICN="1008540319V974321";
		String identifierExtension ="^NI";
		String identfierExtensionFinal = ICN.concat(identifierExtension);
		patientIdentifierValue.setRoot("2.16.840.1.113883.4.349"); patientIdentifierValue.setExtension(identfierExtensionFinal);
		patientIdentifier.setSemanticsText("Patient.Id");
		
		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1309Doc.xmlText(options));

        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);
        
        boolean valid =root1309Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1309 Get Corresponding Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }
      return root1309Doc.xmlText();

	}

}
